<?php
include 'conexao.php';
session_start();

if (!isset($_GET['professor_id'])) {
    echo "Professor não selecionado.";
    exit;
}

$professor_id = intval($_GET['professor_id']);
$resProf = $conn->query("SELECT nome FROM usuarios WHERE id = $professor_id");
$professor_nome = $resProf->fetch_assoc()['nome'];
$filtro = "WHERE h.professor = '" . $conn->real_escape_string($professor_nome) . "'";
$descricaoFiltro = "do Professor: " . $professor_nome;
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Horário do Professor</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        h3 { text-align: center; }
        table { border-collapse: collapse; width: 100%; margin-top: 20px; }
        td, th { border: 1px solid #ccc; padding: 8px; text-align: center; }
        @media print {
            button { display: none; }
        }
    </style>
</head>
<body>

<h3>Horário <?= $descricaoFiltro ?></h3>

<?php
$dias_semana = ['Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta'];
$horario = [];

$sql = "SELECT h.dia, h.tempo, h.disciplina, t.nome AS turma, t.classe, t.curso, t.turno, t.sala
        FROM horario h
        JOIN turmas t ON h.turma_id = t.id
        $filtro";

$res = $conn->query($sql);

while ($row = $res->fetch_assoc()) {
    $hora = $row['tempo'];
    $dia = $row['dia'];
    $texto = $row['disciplina'] . "<br><small>" .
             $row['turma'] . " " . $row['classe'] . " " . $row['curso'] .
             " (" . $row['turno'] . ") - Sala: " . $row['sala'] . "</small>";
    $horario[$hora][$dia] = $texto;
}

$faixas_horas = array_keys($horario);
sort($faixas_horas);
?>

<table>
    <thead>
    <tr>
        <th>Horário</th>
        <?php foreach ($dias_semana as $dia): ?>
            <th><?= $dia ?></th>
        <?php endforeach; ?>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($faixas_horas as $hora): ?>
        <tr>
            <td><?= $hora ?></td>
            <?php foreach ($dias_semana as $dia): ?>
                <td><?= $horario[$hora][$dia] ?? '' ?></td>
            <?php endforeach; ?>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>


<!-- Assinatura -->
<br><br><br>
<div style="text-align: right; margin-top: 30px; font-family: Arial, sans-serif;">

 <strong>O Subdirector Pedagógico</strong>

 <br> _______________________
                                   
</div>

</body>
</html>
